<?php

namespace ZS\Usaepay\Helper;

use Magento\Framework\App\Helper\AbstractHelper;
use Magento\Framework\App\Helper\Context;
use Magento\Sales\Api\Data\OrderInterface;
use ZS\Usaepay\Helper\Card;

/**
 * Class Data
 * @package ZS\Usaepay\Helper
 */
class Data extends AbstractHelper
{
    protected $configHelper;

    /**
     * Data constructor.
     * @param Context $context
     * @param Config $configHelper
     */
    public function __construct(
        Context $context,
        Config $configHelper
    ) {
        parent::__construct($context);

        $this->configHelper = $configHelper;
    }

    /**
     * @param $card
     * @return int
     */
    public function getExpirationMonthFromCard($card)
    {
        $expData = $card->getData('cc_exp_month');
        return (int)substr($expData, 0, 2);
    }

    /**
     * @param $card
     * @return int
     */
    public function getExpirationYearFromCard($card)
    {
        $expData = $card->getData('cc_exp_year');
        return (int)('20' . substr($expData, 2));
    }

   /**
    * @param $card
    * @return string
    */
   public function getCardType($card)
   {

      return $this->getExtendedCcType($card->getData('cc_type'));
   }

   /**
    * @param string $cardType
    * @return string
    */
   private function getExtendedCcType($cardType)
   {
      switch ($cardType) {
         case 'VI':
            return 'Visa';
         case 'MC':
            return 'MasterCard';
         case 'AE':
            return 'American Express';
         case 'DC':
            return 'Diners Club';
         case 'DI':
            return 'Discover';
      }
      return $cardType;
   }


    /**
     * @param $card
     * @return string
     */
    public function getCcLast4FromCard($card)
    {
        return '****-' . $card->getData('cc_last4');
    }

    /**
     * @param $number
     * @return string
     */
    public function getHCObfuscatedCard($number)
    {
        return substr($number, 0, 6) . str_repeat('x', 6) . substr($number, -4);
    }

    /**
     * @param $cardType
     * @return string
     */
    public function hcCardTypeToMagento($cardType)
    {
        switch ($cardType) {
            case 'VC': return 'VI'; // Visa
            case 'MC': return 'MC'; // MasterCard
            case 'AM': return 'AE'; // American Express
            case 'DS': return 'DI'; // Discover
            case 'JC': return 'JCB'; // JCB/Diners Club
            default: return 'OT'; // Other
        }
    }

    /**
     * @param string $cardType
     * @return string
     */
    private function getFullCcTypeName($cardType)
    {
        switch ($cardType) {
            case 'VI':
                return 'Visa';
            case 'MC':
                return 'MasterCard';
            case 'AE':
                return 'American Express';
            case 'DC':
                return 'Diners Club';
            case 'DI':
                return 'Discover';
        }

        return $cardType;
    }
}